/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigOriginFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.CommentedConfigurationNodeIntermediary;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.loader.ParsingException;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public final class HoconConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES;
    private static final ConfigRenderOptions DEFAULT_RENDER_OPTIONS;
    private static final ConfigOrigin CONFIGURATE_ORIGIN;
    private final ConfigRenderOptions render;
    private static final Constructor<? extends ConfigValue> CONFIG_OBJECT_CONSTRUCTOR;
    private static final Constructor<? extends ConfigValue> CONFIG_LIST_CONSTRUCTOR;

    public static Builder builder() {
        return new Builder();
    }

    private HoconConfigurationLoader(Builder build) {
        super((AbstractConfigurationLoader.Builder)build, new CommentHandler[]{CommentHandlers.HASH, CommentHandlers.DOUBLE_SLASH});
        this.render = build.render;
    }

    protected void checkCanWrite(ConfigurationNode node) throws ConfigurateException {
        if (!node.isMap() && !node.virtual() && node.raw() != null) {
            throw new ConfigurateException(node, "HOCON can only write nodes that are in map format!");
        }
    }

    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) throws ParsingException {
        Config hoconConfig;
        try {
            hoconConfig = ConfigFactory.parseReader((Reader)reader);
            hoconConfig = hoconConfig.resolve();
        }
        catch (ConfigException ex) {
            throw new ParsingException((ConfigurationNode)node, ex.origin().lineNumber(), 0, ex.origin().description(), null, (Throwable)ex);
        }
        for (Map.Entry ent : hoconConfig.root().entrySet()) {
            HoconConfigurationLoader.readConfigValue((ConfigValue)ent.getValue(), (CommentedConfigurationNode)node.node(new Object[]{ent.getKey()}));
        }
    }

    private static void readConfigValue(ConfigValue value, CommentedConfigurationNode node) {
        if (!value.origin().comments().isEmpty()) {
            node.comment(value.origin().comments().stream().map(input -> {
                String lineStripped = input.replace("\r", "");
                if (!lineStripped.isEmpty() && lineStripped.charAt(0) == ' ') {
                    return lineStripped.substring(1);
                }
                return lineStripped;
            }).collect(Collectors.joining("\n")));
        }
        switch (value.valueType()) {
            case OBJECT: {
                ConfigObject object = (ConfigObject)value;
                if (object.isEmpty()) {
                    node.raw(Collections.emptyMap());
                    break;
                }
                for (Map.Entry ent : object.entrySet()) {
                    HoconConfigurationLoader.readConfigValue((ConfigValue)ent.getValue(), (CommentedConfigurationNode)node.node(new Object[]{ent.getKey()}));
                }
                break;
            }
            case LIST: {
                ConfigList list = (ConfigList)value;
                if (list.isEmpty()) {
                    node.raw(Collections.emptyList());
                    break;
                }
                for (int i = 0; i < list.size(); ++i) {
                    HoconConfigurationLoader.readConfigValue((ConfigValue)list.get(i), (CommentedConfigurationNode)node.node(new Object[]{i}));
                }
                break;
            }
            case NULL: {
                return;
            }
            default: {
                node.raw(value.unwrapped());
            }
        }
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        try {
            if (!node.isMap() && (node.virtual() || node.raw() == null)) {
                writer.write(SYSTEM_LINE_SEPARATOR);
                return;
            }
            ConfigValue value = HoconConfigurationLoader.fromValue(node);
            String renderedValue = value.render(this.render);
            writer.write(renderedValue);
        }
        catch (IOException io) {
            throw new ConfigurateException(node, (Throwable)io);
        }
    }

    private static ConfigValue fromValue(ConfigurationNode node) {
        CommentedConfigurationNodeIntermediary commentedNode;
        String origComment;
        ConfigValue ret;
        Object children;
        if (node.isMap()) {
            children = node.options().mapFactory().create();
            for (Map.Entry ent : node.childrenMap().entrySet()) {
                children.put(String.valueOf(ent.getKey()), HoconConfigurationLoader.fromValue((ConfigurationNode)ent.getValue()));
            }
            ret = HoconConfigurationLoader.newConfigObject((Map<String, ConfigValue>)children);
        } else if (node.isList()) {
            children = new ArrayList();
            for (ConfigurationNode ent : node.childrenList()) {
                children.add(HoconConfigurationLoader.fromValue(ent));
            }
            ret = HoconConfigurationLoader.newConfigList((List<ConfigValue>)children);
        } else {
            ret = ConfigValueFactory.fromAnyRef((Object)node.rawScalar(), (String)CONFIGURATE_ORIGIN.description());
        }
        if (node instanceof CommentedConfigurationNodeIntermediary && (origComment = (commentedNode = (CommentedConfigurationNodeIntermediary)node).comment()) != null) {
            ret = ret.withOrigin(ret.origin().withComments(Arrays.asList(CONFIGURATE_LINE_PATTERN.split(origComment))));
        }
        return ret;
    }

    static ConfigValue newConfigObject(Map<String, ConfigValue> vals) {
        try {
            return CONFIG_OBJECT_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static ConfigValue newConfigList(List<ConfigValue> vals) {
        try {
            return CONFIG_LIST_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root((ConfigurationOptions)options.nativeTypes(NATIVE_TYPES));
    }

    static /* synthetic */ ConfigRenderOptions access$000() {
        return DEFAULT_RENDER_OPTIONS;
    }

    static {
        Class<ConfigValue> listClass;
        Class<ConfigValue> objectClass;
        NATIVE_TYPES = UnmodifiableCollections.toSet((Object[])new Class[]{Double.class, Long.class, Integer.class, Boolean.class, String.class, Number.class});
        DEFAULT_RENDER_OPTIONS = ConfigRenderOptions.defaults().setOriginComments(false).setJson(false);
        CONFIGURATE_ORIGIN = ConfigOriginFactory.newSimple((String)"configurate-hocon");
        try {
            objectClass = Class.forName("com.typesafe.config.impl.SimpleConfigObject").asSubclass(ConfigValue.class);
            listClass = Class.forName("com.typesafe.config.impl.SimpleConfigList").asSubclass(ConfigValue.class);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            CONFIG_OBJECT_CONSTRUCTOR = objectClass.getDeclaredConstructor(ConfigOrigin.class, Map.class);
            CONFIG_OBJECT_CONSTRUCTOR.setAccessible(true);
            CONFIG_LIST_CONSTRUCTOR = listClass.getDeclaredConstructor(ConfigOrigin.class, List.class);
            CONFIG_LIST_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, HoconConfigurationLoader> {
        private ConfigRenderOptions render = HoconConfigurationLoader.access$000();

        Builder() {
        }

        public Builder prettyPrinting(boolean prettyPrinting) {
            this.render = this.render.setFormatted(prettyPrinting);
            return this;
        }

        public Builder emitComments(boolean emitComments) {
            this.render = this.render.setComments(emitComments);
            return this;
        }

        public Builder emitJsonCompatible(boolean jsonCompatible) {
            this.render = this.render.setJson(jsonCompatible);
            return this;
        }

        public HoconConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new HoconConfigurationLoader(this);
        }
    }
}

